use <common.scad>
use <ccube.scad>
use <Encoder ring generator 2.scad>

//mirror holder
//Z=0 is level of laser plane
//(0,0,0) is the center of the projection

msize=[160,18,4.90]; //large mirror L,W,H
//msize=[155,12.34,4.88]; //smaller mirror L,W,H
mbrs=17.9;//radius for motor mount bolts
ebrs=27;//radius for encoder bolts
encoder_bolt_coords=[for(a=[0:60:359]) ebrs*[cos(a),sin(a)] ];//[x,y] coords for encoder bolts M2.5
motor_proj_offset=16;//total height between top of motor and plane of central reflection (laser beam plane)
enc_ring_offset=10.4;//height between top of motor and top of encoder ring (bottom of mirror holder)
delta=0.01;

/*
module halfcube(sidelen,zh){
    difference(){
        cube([sidelen,sidelen,zh]);
        rotate([0,0,45])translate([sidelen/sqrt(2),-sidelen,-1])cube([2*sidelen,2*sidelen,zh+2]);
    }
}
module alignencl(){
    mirrorencl();
    $fn=16;
    translate([0,0,-11])cylinder(h=11-2,d=1.5);
    translate([0,0,-2-0.1])cylinder(h=4+0.2,d=2);
    translate([0,0,2])cylinder(h=2,d=1.5);
}*/

module mirrorencl(){
    difference(){
        translate([0,0,-motor_proj_offset])
        {
            ccube([20,25,12],[0.4,0.5,0]);
            for(a=[0:120:359]) rotate([0,0,a-15]) slice(1,21,2,30);//cutout attachment to make 3 sections around base
        }
        mirrorcl();
        for(a=[0:120:359]){
            rotate([0,0,a])translate([mbrs,0,-motor_proj_offset-delta])cylinder(h=5,d=2.5);//M2 bolts for mounting to motor with extra clearance to allow accurate centering of encoder ring
        }
    }
}

module mirrorbars(){
    motoroffset=1.2;//distance from top of motor to bottom of the bar holder
    mirroffset=0.2;//extra distance to cut in front of mirror
    bdepth=0.2;//distance of surfaces set into bars
    bthick=1.0;//thickness of bars
    wthick=0.44;//thickness of mirror-adjacent wall surfaces
    bext=[25,25,12];//equivalent cube extents of bars
    nbars=7;//number of bars
    voffset=-(msize[2]/2)/cos(45); //how far down to move origin-centered rotated mirror so that center of reflection is at origin
    difference(){
        union(){
            translate([0,0,-motor_proj_offset+motoroffset])
            {
                b=(bext[1]-bthick)/2;
                c=(bext[1]-bthick)/(nbars-1);
                for(a=[1,2.0,2.9,4,5.1,6,7]) translate([0,-b+c*(a-1),0]) ccube([bext[0],bthick,bext[2]],[0.5,0.5,0]);
                //ccube(bext,[0.5,0.5,0]);
            }
            rotate([0,0,90])translate([0,0,voffset])rotate([45,0,0])translate([0,-3.2,-msize[2]/2-wthick/2-bdepth])cube([bext[1],16,wthick],center=true);//surface for back of mirror
            rotate([0,0,90])translate([0,0,voffset])rotate([45,0,0])translate([0,-7.2,msize[2]/2+wthick/2+bdepth+mirroffset])cube([bext[1],11,wthick],center=true);//surface for front of mirror
            for(a=[0:5]){
                rotate([0,0,90])translate([0,0,voffset])rotate([45,0,0])translate([0,-msize[1]/2-wthick/2-bdepth+a*2.19,0.16])cube([bext[1],wthick,8],center=true);//surface for bottom of mirror and back/front glue holding aids, move slightly for balance adjustments
            }
            translate([bext[0]/2,0,-motor_proj_offset+motoroffset])ccube([1,bext[1],bext[2]],[1,0.5,0]);//cover surface in front
            translate([-bext[0]/2,0,-motor_proj_offset+motoroffset])ccube([1,bext[1],bext[2]],[0,0.5,0]);//cover surface in back
            //translate([-4,0,-motor_proj_offset+motoroffset])ccube([0.5,bext[1],bext[2]],[0,0.5,0]);//stiffening surface in middle
            for(a=[0:120:359]){
                difference(){
                    //translate([-bext[0]/2,-bext[1]/2+delta,-motor_proj_offset+motoroffset+4.6])ccube([7,7+delta,1.5],[0,1,0]);//bolt connector back 1
                    rotate([0,0,a])translate([12,0,-motor_proj_offset+motoroffset+4.1])ccube([9,6.5,1.5],[0,0.5,0]);//bolt connector back 1
                    rotate([0,0,a])translate([mbrs,0,-motor_proj_offset+motoroffset+4.1-delta])cylinder($fn=12, h=5, d=2.5);//M2 bolt + extra room for alignment
                }
            }
            for(a=[0:120:359]){
                y=6.2;
                x=14.5;
                z=-11.95;
                for(b=[-1,1]){
                    rotate([0,0,a])translate([x+2,b*y,z])rotate([90,0,0])rotate([0,90,0])bboltholder();
                }
                rotate([0,0,a])translate([x+3.5-13,0,z])ccube([1,6,5.7],[0,0.5,0.5]);
            }
        }
        rotate([0,0,90])translate([0,0,voffset])rotate([45,0,0])translate([0,0,mirroffset/2])cube([msize[0],msize[1],msize[2]+mirroffset],center=true);
        //rotate([0,0,270])translate([0,-12,voffset+0.3])rotate([60,0,0])translate([0,3.8,mirroffset/2])cube([msize[0],msize[1],msize[2]+mirroffset],center=true);
        translate([0,0,-3.46])ccube([bext[0]*2,bext[1]*2,10],[0.5,0.5,0]);
        for(a=[0:120:359]){
                y=6.2;
                x=14.5;
                z=-11.95;
                for(b=[-1,1]){
                    rotate([0,0,a])translate([x+2,b*y,z])rotate([90,0,0])rotate([0,90,0])bbhcut();
                }
            }
    }
    /*difference(){
        //translate([-bext[0]/2,bext[1]/2-delta,-motor_proj_offset+motoroffset+4.6])ccube([7,7+delta,1.5],[0,0,0]);//bolt connector back 2
        rotate([0,0,120])translate([12,0,-motor_proj_offset+motoroffset+4.6])ccube([9,7+delta,1.5],[0,0.5,0]);//bolt connector back 2
        rotate([0,0,120])translate([mbrs,0,-motor_proj_offset+motoroffset+4.6-delta])cylinder($fn=12, h=5, d=2.5);
    }
    difference(){
        //translate([bext[0]/2-delta,0,-motor_proj_offset+motoroffset+4.6])ccube([9+delta,7,1.5],[0,0.5,0]);//bolt connector front
        rotate([0,0,0])translate([12,0,-motor_proj_offset+motoroffset+4.6])ccube([9,7+delta,1.5],[0,0.5,0]);//bolt connector front
        rotate([0,0,0])translate([mbrs,0,-motor_proj_offset+motoroffset+4.6-delta])cylinder($fn=12, h=5, d=2.5);
    }*/
    translate([-15,0,0])difference(){
        translate([0,0,2])ccube([0.5,9,6],[0,0.5,1]);
        translate([-delta,0,0])ccube([10,1,4+delta*2],[0,0.5,0.5]);
    }//laser alignment aperture at back
    
    translate([-9.5,0,0])union(){
        translate([0,0,2])ccube([0.5,9,6],[0,0.5,1]);
        translate([-0.2,0,0])ccube([0.7,1,4],[0,0.5,0.5]);
        //translate([0,0,-4])ccube([5+delta,8,0.5],[1,0.5,0]);
        translate([delta,4.5,-4])ccube([5+delta*2,0.5,6],[1,1,0]);
        translate([delta,-4.5,-4])ccube([5+delta*2,0.5,6],[1,0,0]);
    }//laser alignment target wall at back
    
}

module mirrorcl(){
    voffset=-(msize[2]/2)/cos(45); //how far down to move origin-centered rotated mirror so that center of reflection is at origin
    echo("Vertical offset", voffset);
    rotate([0,0,90])translate([0,0,voffset])rotate([45,0,0])cube(msize,center=true);
}

module slice(ri,ro,h,a){
    //pie slice around Z axis by angle a
    rotate_extrude(angle=a)translate([ri,0,0])square([ro-ri,h]);
}

module laserbeam(l,a){
    rotate([0,0,a])translate([-2,-1,-2])cube([l,2,4]);
}

module ringholder(){
    motord=42;//motor diameter
    difference(){
            union(){
                translate([0,0,-enc_ring_offset])cylinder(h=1+enc_ring_offset,d=motord+2*2);//disk on top of and surrounding motor
                translate([0,0,-enc_ring_offset])cylinder(h=1,d=2*ebrs+8);//disk for mounting encoder
            }
            translate([0,0,-delta])cylinder($fn=36,h=5,d=2*mbrs-6);//disk on top of motor
            rotate([0,0,-60])translate([0,0,-delta])ccube([30,26,6],[0,0.5,0]);//rectangle on top of motor for mirror holder
            translate([0,0,-enc_ring_offset-delta])cylinder(h=enc_ring_offset+delta,d=motord+1*2);//clearance surrounding motor
            //translate([0,0,base_th])cylinder(h=5,d=30);//cutout inside stiffening ring on top of motor
            translate([0,0,-enc_ring_offset+4+delta]) for(a=[10:120:359]) rotate([0,0,a+5]) slice(1,35,enc_ring_offset+delta,90);//cutout encoder ring attachment to make 3 sections around base
                q=0.67;//decrease width of back attachment to balance component
                translate([0,0,-enc_ring_offset+4+delta]) rotate([0,0,135-q]) slice(1,35,enc_ring_offset+delta,10);//cutout back CW
            translate([0,0,-enc_ring_offset+4+delta]) rotate([0,0,105-10+q]) slice(1,35,enc_ring_offset+delta,10);//cutout back CCW
            for(a=[0:60:359]){
                rotate([0,0,a])translate([ebrs,0,-enc_ring_offset-delta])cylinder($fn=12, h=5,d=3.0);//M2.5 bolts for mounting to encoder with extra clearance to allow accurate centering of encoder ring
            }
            for(a=[0:120:359]){
                rotate([0,0,a])translate([mbrs,0,-2-delta])cylinder($fn=12, h=5,d=2.5);//M2 bolts for mounting to motor with extra clearance to allow accurate centering of encoder ring
            }
            
            //bolts_subtract(mirh_bolt_coords, base_th, 2, base_th+delta);//M2.5 bolts for mounting to motor
            //bolts_subtract(encoder_bolt_coords, -enc_ring_offset+enc_mount_th, 3.0, enc_mount_th+delta);//M2.5+ bolts for mounting to encoder with extra clearance to allow accurate centering of encoder ring
    }//circle section
}

module ringholderbase(){
    difference(){
        ringholder();
        translate([0,0,-7])cylinder(h=30, r=50);
    }
}

module fanmotor(){
    //PCB cutout hole ID 50 mm
    //(16 to 16.5) mm from motor top to beam plane when installed in 20250430 box
    //17.9 mm radius of drilled M2 bolt holes in plastic rotor
    //motor total height 23.2 mm, diameter 42 mm 
    //6 mm long M2 bolts expected to extend about 5 mm above top of rotor
    cylinder(h=4.5,d=42);
    for(a=[0:90:359]){
        s=118;
        rotate([0,0,a]){
            translate([0,21,0])ccube([s/2,5,4.5],[0,1,0]);
            translate([0,s/2,0])ccube([s,5,4.5],[0.5,1,0]);
        }
    }
    translate([0,0,3])cylinder(h=4.5,d=30);
    /*translate([0,0,5.5])//drilled holes
    difference(){
        cylinder(h=17.7,d=42);
        for(a=[0:60:359]){
            rotate([0,0,a])translate([17.9,0,10])cylinder(h=18,d=2);
        }
    }*/
    translate([0,0,5.5])cylinder(h=17.7,d=42);//rotor
    for(a=[0:120:359]){//inserted long bolts and nuts
        rotate([0,0,a])translate([17.9,0,23.2-1])cylinder(h=12,d=2);//cylinder h = bolt length, head is inserted 1mm below top of rotor
        rotate([0,0,a])translate([17.9,0,23.2])m2washer();
        rotate([0,0,a])translate([17.9,0,23.2+0.4])m2nut();
        rotate([0,0,a])translate([17.9,0,23.2+2.7+0.4])rotate([0,0,30])m2nut();
        rotate([0,0,a])translate([17.9,0,23.2+4.4+0.4])m2washer();
        rotate([0,0,a])translate([17.9,0,23.2+6.4+0.4])m2washer();
        rotate([0,0,a])translate([17.9,0,23.2+6.9+0.4])m2nut();
        rotate([0,0,a])translate([17.9,0,23.2+9.0])rotate([0,0,30])m2nut();
    }
    for(a=[60:120:359]){//inserted short bolts and nuts
        rotate([0,0,a])translate([17.9,0,23.2-1])cylinder(h=8,d=2);//cylinder h = bolt length, head is inserted 1mm below top of rotor
        rotate([0,0,a])translate([17.9,0,23.2+1.1])m2washer();
        rotate([0,0,a])translate([17.9,0,23.2+1.6])m2nut();
    }
}

module pcbhole(){
    difference(){
        cylinder(h=1.6,d=90);
        translate([0,0,-1])cylinder(h=4,d=60);
    }
}

module bboltholder(){
    //nut front surface at Z=0
    nw=5;//distance between M2.5 nut flats
    nh=nw/cos(30);//height to include M2.5 nut
    nl=13.0;//overall length front to back
    wt=[1,1.5,1.5,1];//wall thickness: sides,front of nut,behind nut, back
    difference(){
        union(){
            ccube([nw+2*delta,nh,wt[1]],[0.5,0.5,0]);//front of nut
            translate([0,0,-2])ccube([nw+2*delta,nh,wt[2]],[0.5,0.5,1]);//back of nut
            translate([0,0,-nl+wt[1]])ccube([nw+2*delta,nh,wt[3]],[0.5,0.5,0]);//back of holder
            translate([-nw/2,0,wt[1]])ccube([wt[0],nh,nl],[1,0.5,1]);//left of holder
            translate([nw/2,0,wt[1]])ccube([wt[0],nh,nl],[0,0.5,1]);//right of holder
        }
        bbhcut();
    }
}

module bbhcut(){
    //nut front surface at Z=0
    nw=5;//distance between M2.5 nut flats
    nh=nw/cos(30);//height to include M2.5 nut
    nl=13.0;//overall length front to back
    wt=[1,1.5,1.5,1];//wall thickness: sides,front of nut,behind nut, back
    translate([0,0,-nl+wt[1]+wt[3]+delta])cylinder($fn=10,h=nl+delta,d=2.5);//bolt hole tight
    //translate([0,0,-nl+wt[1]+wt[3]+delta])cylinder($fn=10,h=nl-wt[1]-wt[3]-wt[2]-2-delta,d=2.7);//bolt hole loose
    //translate([0,0,wt[1]+delta])cylinder($fn=10,h=10,d=5.5);//bolt head flat surface
    ccube([nw,nh,2],[0.5,0.5,1]);//nut insert
}

module balancebolts(){
    for(a=[0:120:359]){
    y=6.2;
    z=-11.95;
    for(b=[-1,1]){
            rotate([0,0,a])translate([18+7*0.5,b*y,z])rotate([0,90,0])m25bolt(12);
            rotate([0,0,a])translate([14.5,b*y,z])rotate([0,90,0])m25nut();
        }   
    }
}


//mirrorencl();
//alignencl();

//mirholder();

//metalrod();

//mirrorcl();
//mirrorbars();
//balancebolts();
//laserbeam(100,0);
//translate([0,0,-motor_proj_offset])pcbhole();
//ringholder();
//optoextender();

translate([0,0,-motor_proj_offset]){//(16 to 16.5) mm from motor top to beam plane when installed in 20250430 box
    translate([0,0,-23.2])fanmotor();//translate so top of motor is at Z=0
translate([0,0,0])pcbhole();//for visual reference of where PCB is
rotate([0,0,60])ringholder();
    translate([0,0,-21])rotate([180,0,0])ringholderbase();
translate([0,0,-enc_ring_offset])ring3d();
translate([77.5/2+1.78,0,-enc_ring_offset-1-6.8])optoisolatorasm();
translate([77.5/2+1.78,0,-enc_ring_offset-1-6.8])optoextender();
}

//translate([0,0,-40])motor();

//mirholderasm();

//translate([14,-7,-5])rotate([180,0,0])m2bolt(6);

//translate([0,-8,-14.4])m25bolt(6);
//translate([0,-8,-15])m25washer();

//halfcube(20,2);